package gov.va.vamf.scheduling.facility.datalayer;

import com.agilex.healthcare.mobilehealthplatform.utils.QueryParameters;
import edu.emory.mathcs.backport.java.util.Arrays;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.net.URI;

@Component
public class FacilityFilterFactory {

	@Resource
	FacilityCache facilityCache;
	
	public FacilityFilter createFromUri(URI u) {
		QueryParameters queryParameters = new QueryParameters(u.getQuery());
		String siteCodes = queryParameters.getValue("parentSiteCodes");
		String[] parentSiteCodes = siteCodes.split(",");

		FacilityFilter facilityFilter = new FacilityFilter(facilityCache);
		facilityFilter.setParentSiteCode(Arrays.asList(parentSiteCodes));
		
		return facilityFilter;
	}

}
